/*
 * Decompiled with CFR 0.152.
 */
package energysim.sim;

import energysim.ScenarioResult;
import energysim.csv.Loader;
import energysim.csv.Writer;
import energysim.model.EnergyUsage;
import energysim.model.LoadScenario;
import energysim.model.PowerStorage;
import energysim.model.ReferenceScenario;
import energysim.model.Scenario;
import java.text.DecimalFormat;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J/\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0012J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"Lenergysim/sim/SimulationService;", "", "loader", "Lenergysim/csv/Loader;", "writer", "Lenergysim/csv/Writer;", "<init>", "(Lenergysim/csv/Loader;Lenergysim/csv/Writer;)V", "getLoader", "()Lenergysim/csv/Loader;", "getWriter", "()Lenergysim/csv/Writer;", "decimalFormat", "Ljava/text/DecimalFormat;", "getDecimalFormat", "()Ljava/text/DecimalFormat;", "runSimulation", "Lenergysim/ScenarioResult;", "loadProfileFile", "", "powerValueKw", "", "optimal", "", "([BLjava/lang/Integer;Z)Lenergysim/ScenarioResult;", "getBestScenario", "Lenergysim/model/LoadScenario;", "findPeak", "capacityKwh", "", "energysim"})
@SourceDebugExtension(value={"SMAP\nSimulationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimulationService.kt\nenergysim/sim/SimulationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,140:1\n1563#2:141\n1634#2,3:142\n1869#2:145\n1870#2:147\n1563#2:148\n1634#2,3:149\n774#2:152\n865#2,2:153\n1869#2:155\n774#2:156\n865#2,2:157\n1869#2:159\n1563#2:160\n1634#2,3:161\n1870#2:164\n1870#2:165\n1#3:146\n*S KotlinDebug\n*F\n+ 1 SimulationService.kt\nenergysim/sim/SimulationService\n*L\n54#1:141\n54#1:142,3\n67#1:145\n67#1:147\n76#1:148\n76#1:149,3\n89#1:152\n89#1:153,2\n89#1:155\n93#1:156\n93#1:157,2\n93#1:159\n96#1:160\n96#1:161,3\n93#1:164\n89#1:165\n*E\n"})
public class SimulationService {
    @NotNull
    private final Loader loader;
    @NotNull
    private final Writer writer;
    @NotNull
    private final DecimalFormat decimalFormat;

    public SimulationService(@NotNull Loader loader, @NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        this.loader = loader;
        this.writer = writer;
        this.decimalFormat = new DecimalFormat("#.##");
    }

    @NotNull
    public Loader getLoader() {
        return this.loader;
    }

    @NotNull
    public Writer getWriter() {
        return this.writer;
    }

    @NotNull
    public DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ScenarioResult runSimulation(@Nullable byte[] loadProfileFile, @Nullable Integer powerValueKw, boolean optimal) {
        void $this$mapTo$iv$iv;
        Object element$iv2;
        void $this$mapTo$iv$iv2;
        Integer n = powerValueKw;
        double capacityKwh = n != null ? (double)n.intValue() : 250.0;
        int peak = this.findPeak(capacityKwh);
        if (optimal) {
            LoadScenario bestScenario = this.getBestScenario(loadProfileFile);
            PowerStorage powerStorage = bestScenario.getPowerStorage();
            capacityKwh = powerStorage != null ? powerStorage.getCapacityKwh() : capacityKwh;
            peak = bestScenario.getPeak();
        }
        java.time.Duration duration = java.time.Duration.ofMinutes(15L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        java.time.Duration duration2 = duration;
        long simulationStep = Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)duration2.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)duration2.getNano(), (DurationUnit)DurationUnit.NANOSECONDS));
        ReferenceScenario scenario1 = new ReferenceScenario("Kurve ohne Speicher", simulationStep, "black", null);
        LoadScenario scenario3 = new LoadScenario("Ladeszenario (bei \u00dcber/Unterlast) mit " + capacityKwh + " Kwh Batterie", new PowerStorage(0.0, 0.0, capacityKwh, capacityKwh, capacityKwh, 0.0, 0.0, 0.0, 227, null), simulationStep, "#1720A1", peak, null);
        Map readPrices = this.getLoader().readPricesFromXML();
        List energyUsage = this.getLoader().readEnergyUsage(loadProfileFile);
        Iterable $this$map$iv = energyUsage;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void energyUsageEntry;
            EnergyUsage energyUsage2 = (EnergyUsage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Double d = (Double)readPrices.get(energyUsageEntry.getTimestamp().truncatedTo(ChronoUnit.HOURS));
            double currentEnergyPrice = d != null ? d : 0.0;
            scenario1.handle(energyUsageEntry.getTimestamp(), energyUsageEntry.getUsage(), currentEnergyPrice);
            collection.add(scenario3.handle(energyUsageEntry.getTimestamp(), energyUsageEntry.getUsage(), currentEnergyPrice));
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        Object[] $i$f$map22 = new Scenario[]{scenario1, scenario3};
        List listOfScenarios = CollectionsKt.listOf((Object[])$i$f$map22);
        Map resultMap = new LinkedHashMap();
        Iterable $this$forEach$iv = listOfScenarios;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            double d;
            Scenario scenario = (Scenario)element$iv2;
            boolean bl = false;
            Iterable iterable2 = scenario.getScenarioData().getEntries();
            DecimalFormat currentEnergyPrice = this.getDecimalFormat();
            double d2 = 0.0;
            for (Object t : iterable2) {
                void it;
                Triple triple = (Triple)t;
                d = d2;
                boolean bl2 = false;
                double d3 = ((Number)it.getSecond()).doubleValue();
                d2 = d + d3;
            }
            d = d2;
            String string = currentEnergyPrice.format(d);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            double decimalValue = Double.parseDouble(string);
            scenario.getScenarioData().setSumCosts(decimalValue);
            scenario.getScenarioData().setColor(scenario.getColor());
            scenario.calculateTotalCosts();
        }
        System.out.println(resultMap);
        Iterable $this$map$iv2 = listOfScenarios;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Scenario scenario = (Scenario)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(p0.getScenarioData());
        }
        List list = (List)destination$iv$iv2;
        ScenarioResult result = new ScenarioResult(list);
        return result;
    }

    public static /* synthetic */ ScenarioResult runSimulation$default(SimulationService simulationService, byte[] byArray, Integer n, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: runSimulation");
        }
        if ((n2 & 1) != 0) {
            byArray = null;
        }
        if ((n2 & 2) != 0) {
            n = 250;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return simulationService.runSimulation(byArray, n, bl);
    }

    /*
     * WARNING - void declaration
     */
    private LoadScenario getBestScenario(byte[] loadProfileFile) {
        void $this$filterTo$iv$iv;
        java.time.Duration duration = java.time.Duration.ofMinutes(15L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        java.time.Duration duration2 = duration;
        long simulationStep = Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)duration2.getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)duration2.getNano(), (DurationUnit)DurationUnit.NANOSECONDS));
        Map readPrices = new Loader().readPricesFromXML();
        List energyUsage = new Loader().readEnergyUsage(loadProfileFile);
        double minimumPeak = 0.0;
        minimumPeak = Double.MAX_VALUE;
        LoadScenario minimumScenario = null;
        minimumScenario = new LoadScenario("Optimized", new PowerStorage(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 255, null), simulationStep, "", 0, 16, null);
        Iterable $this$filter$iv = (Iterable)new IntRange(1, 80);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(it % 2 == 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$filterTo$iv$iv2;
            int capacityIndex = ((Number)element$iv).intValue();
            boolean bl = false;
            double capacityKwh = (double)capacityIndex * 100.0;
            PowerStorage powerStorage = new PowerStorage(0.0, 0.0, capacityKwh, capacityKwh, capacityKwh, 0.0, 0.0, 0.0, 227, null);
            Iterable $this$filter$iv2 = (Iterable)new IntRange(1, 63);
            boolean $i$f$filter2 = false;
            Iterable iterable2 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                int it = ((Number)element$iv$iv).intValue();
                boolean bl2 = false;
                if (!(it % 2 == 0)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Iterable $this$forEach$iv2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                void $this$mapTo$iv$iv;
                int it = ((Number)element$iv2).intValue();
                boolean bl3 = false;
                LoadScenario scenario = new LoadScenario("Load with peak test" + it, powerStorage, simulationStep, "", it, null);
                Iterable $this$map$iv = energyUsage;
                boolean $i$f$map = false;
                Iterable iterable3 = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void energyUsageEntry;
                    EnergyUsage energyUsage2 = (EnergyUsage)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl4 = false;
                    Double d = (Double)readPrices.get(energyUsageEntry.getTimestamp().truncatedTo(ChronoUnit.HOURS));
                    double currentEnergyPrice = d != null ? d : 0.0;
                    collection.add(scenario.handle(energyUsageEntry.getTimestamp(), energyUsageEntry.getUsage(), currentEnergyPrice));
                }
                List cfr_ignored_0 = (List)destination$iv$iv3;
                if (!(scenario.getMaximumExternalUsagePerPeriod() < minimumPeak)) continue;
                scenario.calculateTotalCosts();
                minimumPeak = scenario.getMaximumExternalUsagePerPeriod();
                minimumScenario = scenario;
                PowerStorage powerStorage2 = scenario.getPowerStorage();
                String string = "Scenario beat the minimum: " + Scenario.roundForDisplaying$default((Scenario)((Scenario)scenario), (double)(minimumPeak * (double)((long)60 / Duration.getInWholeMinutes-impl((long)scenario.getSimulationStep-UwyO8pc()))), (int)0, (int)2, null) + " with peak switch " + (long)scenario.getPeak() * ((long)60 / Duration.getInWholeMinutes-impl((long)scenario.getSimulationStep-UwyO8pc())) + " and Capacity: " + (powerStorage2 != null ? Double.valueOf(powerStorage2.getCapacityKwh()) : null) + " price: " + Scenario.roundForDisplaying$default((Scenario)((Scenario)scenario), (double)scenario.getScenarioData().getSumCosts(), (int)0, (int)2, null) + " + DEBUG: " + scenario.getScenarioData().getDebug();
                System.out.println((Object)string);
            }
        }
        PowerStorage powerStorage = minimumScenario.getPowerStorage();
        String string = "Scenario picked for minimum: " + Scenario.roundForDisplaying$default((Scenario)((Scenario)minimumScenario), (double)(minimumPeak * (double)((long)60 / Duration.getInWholeMinutes-impl((long)minimumScenario.getSimulationStep-UwyO8pc()))), (int)0, (int)2, null) + " with peak switch " + (long)minimumScenario.getPeak() * ((long)60 / Duration.getInWholeMinutes-impl((long)minimumScenario.getSimulationStep-UwyO8pc())) + " and Capacity: " + (powerStorage != null ? Double.valueOf(powerStorage.getCapacityKwh()) : null) + " price: " + Scenario.roundForDisplaying$default((Scenario)((Scenario)minimumScenario), (double)minimumScenario.getScenarioData().getSumCosts(), (int)0, (int)2, null) + " + DEBUG: " + minimumScenario.getScenarioData().getDebug();
        System.out.println((Object)string);
        return minimumScenario;
    }

    private int findPeak(double capacityKwh) {
        return capacityKwh < 1000.0 ? 50 : (capacityKwh < 2000.0 ? 35 : 25);
    }
}

