/*
 * Decompiled with CFR 0.152.
 */
package energysim.model;

import energysim.ScenarioData;
import energysim.model.PowerStorage;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * Exception performing whole class analysis ignored.
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u001e\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0014J\u0006\u0010%\u001a\u00020&J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0014H&J\u0018\u0010*\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0014H&J\u0018\u0010+\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0014H&J\u0018\u0010,\u001a\u00020\u00142\u0006\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u0014H&J\u0018\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u00142\b\b\u0002\u0010/\u001a\u000200J\u000e\u00101\u001a\u00020\u00142\u0006\u00102\u001a\u00020\u0014J\u000e\u00103\u001a\u00020\u00142\u0006\u00104\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00065"}, d2={"Lenergysim/model/Scenario;", "", "name", "", "powerStorage", "Lenergysim/model/PowerStorage;", "simulationStep", "Lkotlin/time/Duration;", "color", "<init>", "(Ljava/lang/String;Lenergysim/model/PowerStorage;JLjava/lang/String;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getName", "()Ljava/lang/String;", "getPowerStorage", "()Lenergysim/model/PowerStorage;", "getSimulationStep-UwyO8pc", "()J", "J", "getColor", "totalExternalUsage", "", "getTotalExternalUsage", "()D", "setTotalExternalUsage", "(D)V", "maximumExternalUsagePerPeriod", "getMaximumExternalUsagePerPeriod", "setMaximumExternalUsagePerPeriod", "scenarioData", "Lenergysim/ScenarioData;", "getScenarioData", "()Lenergysim/ScenarioData;", "handle", "currentTime", "Ljava/time/LocalDateTime;", "currentEnergyUsageInternal", "currentEnergyPrice", "calculateTotalCosts", "", "decisionToDischarge", "", "energyUsageInternal", "decisionToCharge", "decisionHowMuchToCharge", "decisionHowMuchToDischarge", "roundForDisplaying", "double", "decimals", "", "calcKwh", "kwStep", "calcFractionKw", "kwh", "energysim"})
public abstract class Scenario {
    @NotNull
    private final String name;
    @Nullable
    private final PowerStorage powerStorage;
    private final long simulationStep;
    @NotNull
    private final String color;
    private double totalExternalUsage;
    private double maximumExternalUsagePerPeriod;
    @NotNull
    private final ScenarioData scenarioData;

    private Scenario(String name, PowerStorage powerStorage, long simulationStep, String color) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.name = name;
        this.powerStorage = powerStorage;
        this.simulationStep = simulationStep;
        this.color = color;
        this.scenarioData = new ScenarioData(this.name, (List)new ArrayList(), 0.0, "black", "");
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final PowerStorage getPowerStorage() {
        return this.powerStorage;
    }

    public final long getSimulationStep-UwyO8pc() {
        return this.simulationStep;
    }

    @NotNull
    public final String getColor() {
        return this.color;
    }

    public final double getTotalExternalUsage() {
        return this.totalExternalUsage;
    }

    public final void setTotalExternalUsage(double d) {
        this.totalExternalUsage = d;
    }

    public final double getMaximumExternalUsagePerPeriod() {
        return this.maximumExternalUsagePerPeriod;
    }

    public final void setMaximumExternalUsagePerPeriod(double d) {
        this.maximumExternalUsagePerPeriod = d;
    }

    @NotNull
    public final ScenarioData getScenarioData() {
        return this.scenarioData;
    }

    public final double handle(@NotNull LocalDateTime currentTime, double currentEnergyUsageInternal, double currentEnergyPrice) {
        double oldSoc;
        Intrinsics.checkNotNullParameter((Object)currentTime, (String)"currentTime");
        boolean charged = false;
        Object actionString = "";
        double currentEnergyUsage = this.calcFractionKw(currentEnergyUsageInternal);
        if (this.powerStorage != null && this.powerStorage.getSoc() < 0.9999 && this.decisionToCharge(currentEnergyUsage, currentEnergyPrice)) {
            oldSoc = this.powerStorage.getSoc();
            double chargeKwMax = this.calcFractionKw(this.powerStorage.getChargeSpeedKwh());
            double chargeKwMaximumTechnical = RangesKt.coerceAtMost((double)chargeKwMax, (double)(this.powerStorage.getCapacityKwh() - this.powerStorage.getSoc() * this.powerStorage.getCapacityKwh()));
            double chargeKw = RangesKt.coerceAtMost((double)chargeKwMaximumTechnical, (double)this.decisionHowMuchToCharge(currentEnergyUsage, currentEnergyPrice));
            this.powerStorage.setSoc((this.powerStorage.getCapacityKwh() * this.powerStorage.getSoc() + chargeKw) / this.powerStorage.getCapacityKwh());
            PowerStorage powerStorage = this.powerStorage;
            powerStorage.setChargeCycles(powerStorage.getChargeCycles() + Math.abs(this.powerStorage.getSoc() - oldSoc));
            actionString = this.name + "# Internalusage:" + currentEnergyUsageInternal + " - charged " + this.roundForDisplaying(chargeKw, 2) + " with " + this.roundForDisplaying(this.calcKwh(chargeKw), 2) + "kwh from " + this.roundForDisplaying(oldSoc, 4) + " -> " + this.roundForDisplaying(this.powerStorage.getSoc(), 4);
            currentEnergyUsage += chargeKw;
            charged = true;
        }
        if (this.powerStorage != null && !charged && this.powerStorage.getSoc() > 1.0 - this.powerStorage.getDod() && currentEnergyUsageInternal > 0.0 && this.decisionToDischarge(currentEnergyUsage, currentEnergyPrice)) {
            oldSoc = this.powerStorage.getSoc();
            double disChargeKwMax = this.calcFractionKw(this.powerStorage.getDischargeSpeedKwh());
            double disChargeKwTechnical = RangesKt.coerceAtMost((double)currentEnergyUsageInternal, (double)disChargeKwMax);
            double disChargeKw = RangesKt.coerceAtMost((double)disChargeKwTechnical, (double)this.decisionHowMuchToDischarge(currentEnergyUsage, currentEnergyPrice));
            double newSoc = (this.powerStorage.getCapacityKwh() * this.powerStorage.getSoc() - disChargeKw) / this.powerStorage.getCapacityKwh();
            if (newSoc >= 1.0 - this.powerStorage.getDod()) {
                this.powerStorage.setSoc(newSoc);
                PowerStorage powerStorage = this.powerStorage;
                powerStorage.setChargeCycles(powerStorage.getChargeCycles() + Math.abs(oldSoc - this.powerStorage.getSoc()));
                actionString = this.name + "# Internalusage:" + currentEnergyUsageInternal + " - discharged " + this.roundForDisplaying(disChargeKw, 2) + " with " + this.roundForDisplaying(this.calcKwh(disChargeKw), 2) + "kwh  from " + this.roundForDisplaying(oldSoc, 4) + " to " + this.roundForDisplaying(this.powerStorage.getSoc(), 4);
                currentEnergyUsage -= disChargeKw;
            }
        }
        if (currentEnergyUsage > this.maximumExternalUsagePerPeriod) {
            this.maximumExternalUsagePerPeriod = currentEnergyUsage;
        }
        double truncatedEnergyUsage = RangesKt.coerceAtLeast((double)currentEnergyUsage, (double)0.0);
        this.totalExternalUsage += truncatedEnergyUsage;
        double calculatedPrice = truncatedEnergyUsage * currentEnergyPrice;
        this.scenarioData.getEntries().add(new Triple((Object)currentTime, (Object)this.calcKwh(currentEnergyUsage), actionString));
        return calculatedPrice;
    }

    public final void calculateTotalCosts() {
        double maximumUsagePeakInKwH = this.calcKwh(this.maximumExternalUsagePerPeriod);
        double hoursPerYearUsed = this.totalExternalUsage / maximumUsagePeakInKwH;
        double pricePerKwYear = hoursPerYearUsed < 2500.0 ? 51.16 : 270.97;
        double pricePerKwHours = hoursPerYearUsed < 2500.0 ? 0.0959 : 0.008;
        double priceForMaximum = maximumUsagePeakInKwH * pricePerKwYear;
        double priceForUsage = this.totalExternalUsage * pricePerKwHours;
        this.scenarioData.setSumCosts(Scenario.roundForDisplaying$default((Scenario)this, (double)(priceForMaximum + priceForUsage), (int)0, (int)2, null));
        this.scenarioData.setDebug("T:" + Scenario.roundForDisplaying$default((Scenario)this, (double)this.totalExternalUsage, (int)0, (int)2, null) + "/MAX:" + Scenario.roundForDisplaying$default((Scenario)this, (double)maximumUsagePeakInKwH, (int)0, (int)2, null) + "/H:" + Scenario.roundForDisplaying$default((Scenario)this, (double)hoursPerYearUsed, (int)0, (int)2, null));
    }

    public abstract boolean decisionToDischarge(double var1, double var3);

    public abstract boolean decisionToCharge(double var1, double var3);

    public abstract double decisionHowMuchToCharge(double var1, double var3);

    public abstract double decisionHowMuchToDischarge(double var1, double var3);

    public final double roundForDisplaying(double d, int decimals) {
        return new BigDecimal(d).setScale(decimals, RoundingMode.HALF_UP).doubleValue();
    }

    public static /* synthetic */ double roundForDisplaying$default(Scenario scenario, double d, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: roundForDisplaying");
        }
        if ((n2 & 2) != 0) {
            n = 2;
        }
        return scenario.roundForDisplaying(d, n);
    }

    public final double calcKwh(double kwStep) {
        return kwStep * (double)((long)60 / Duration.getInWholeMinutes-impl((long)this.simulationStep));
    }

    public final double calcFractionKw(double kwh) {
        return kwh * ((double)Duration.getInWholeMinutes-impl((long)this.simulationStep) / 60.0);
    }

    public /* synthetic */ Scenario(String name, PowerStorage powerStorage, long simulationStep, String color, DefaultConstructorMarker $constructor_marker) {
        this(name, powerStorage, simulationStep, color);
    }
}

