/*
 * Decompiled with CFR 0.152.
 */
package energysim.csv;

import energysim.model.EnergyUsage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Service
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0016J\u0014\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u0016J\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n2\u0006\u0010\u0010\u001a\u00020\u000fH\u0012\u00a8\u0006\u0011"}, d2={"Lenergysim/csv/Loader;", "", "<init>", "()V", "readPrices", "", "Ljava/time/LocalDateTime;", "", "readPricesFromXML", "readEnergyUsage", "", "Lenergysim/model/EnergyUsage;", "content", "", "getRecordFromLine", "", "line", "energysim"})
@SourceDebugExtension(value={"SMAP\nLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Loader.kt\nenergysim/csv/Loader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1193#2,2:116\n1267#2,4:118\n1617#2,9:122\n1869#2:131\n1870#2:133\n1626#2:134\n1#3:132\n*S KotlinDebug\n*F\n+ 1 Loader.kt\nenergysim/csv/Loader\n*L\n25#1:116,2\n25#1:118,4\n90#1:122,9\n90#1:131\n90#1:133\n90#1:134\n90#1:132\n*E\n"})
public class Loader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public Map<LocalDateTime, Double> readPrices() {
        void $this$associateTo$iv$iv;
        List records = new ArrayList();
        Closeable closeable = new Scanner(new File("Spotmarkt_Preise_01_2019_bis_07_2024.csv"));
        Throwable throwable = null;
        try {
            Scanner scanner = (Scanner)closeable;
            boolean bl = false;
            while (scanner.hasNextLine()) {
                String string = scanner.nextLine();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextLine(...)");
                records.add(this.getRecordFromLine(string));
            }
            scanner = Unit.INSTANCE;
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Iterable $this$associate$iv = records;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable bl = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            List it = (List)element$iv$iv;
            boolean bl2 = false;
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("M/d/yyyy HH:mm:ss");
            LocalDateTime localDateTime = LocalDateTime.parse(it.get(0) + " " + StringsKt.takeLast((String)("0" + it.get(1)), (int)8), dateTimeFormatter);
            Pair pair = TuplesKt.to((Object)localDateTime, (Object)Double.parseDouble((String)it.get(2)));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @NotNull
    public Map<LocalDateTime, Double> readPricesFromXML() {
        Map records = new LinkedHashMap();
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputStream inputStream = new ClassPathResource("2023_prices.xml").getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        InputStream inputStream2 = inputStream;
        Document document = builder.parse(inputStream2);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"parse(...)");
        Document doc = document;
        doc.getDocumentElement().normalize();
        NodeList dayEntries = doc.getElementsByTagName("donneesMarche");
        int n = dayEntries.getLength();
        for (int dayIndex = 0; dayIndex < n; ++dayIndex) {
            Node node = dayEntries.item(dayIndex);
            String dateString = node.getAttributes().getNamedItem("date").getNodeValue();
            NodeList typeEntries = node.getChildNodes();
            int n2 = typeEntries.getLength();
            for (int typeIndex = 0; typeIndex < n2; ++typeIndex) {
                Node node2 = typeEntries.item(typeIndex);
                String countryCode = node2.getAttributes().getNamedItem("perimetre").getNodeValue();
                NodeList valueList = node2.getChildNodes();
                int n3 = valueList.getLength();
                for (int valueIndex = 0; valueIndex < n3; ++valueIndex) {
                    Node node3 = valueList.item(valueIndex);
                    String hourValue = StringsKt.takeLast((String)("0" + node3.getAttributes().getNamedItem("periode").getNodeValue()), (int)2);
                    String string = node3.getTextContent();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextContent(...)");
                    Double costValue = StringsKt.toDoubleOrNull((String)string);
                    DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
                    LocalDateTime localDateTime = LocalDateTime.parse(dateString + " " + hourValue + ":00", dateTimeFormatter);
                    if (!countryCode.equals("DL") || costValue == null) continue;
                    records.put(localDateTime, costValue / 1000.0);
                }
            }
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public List<EnergyUsage> readEnergyUsage(@Nullable byte[] content) {
        void $this$mapNotNullTo$iv$iv;
        Object scanner;
        byte[] usage = null;
        usage = content == null ? FilesKt.readBytes((File)new File("2023.csv")) : content;
        List records = new ArrayList();
        Closeable closeable = new Scanner(new ByteArrayInputStream(usage));
        Throwable throwable = null;
        try {
            scanner = (Scanner)closeable;
            boolean bl = false;
            while (((Scanner)scanner).hasNextLine()) {
                String string = ((Scanner)scanner).nextLine();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextLine(...)");
                records.add(this.getRecordFromLine(string));
            }
            scanner = Unit.INSTANCE;
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Iterable $this$mapNotNull$iv = records;
        boolean $i$f$mapNotNull = false;
        scanner = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            EnergyUsage energyUsage;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            List it = (List)element$iv$iv;
            boolean bl2 = false;
            int n = it.size();
            if (!(2 <= n ? n < 4 : false)) {
                energyUsage = null;
            } else {
                String date = (String)it.get(0);
                String time = StringsKt.takeLast((String)("0" + it.get(1)), (int)8);
                double consumption = StringsKt.isBlank((CharSequence)((CharSequence)it.get(2))) || Intrinsics.areEqual(it.get(2), (Object)"---") ? 0.0 : Double.parseDouble((String)it.get(2));
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("M/d/yyyy HH:mm:ss");
                LocalDateTime localDateTime = LocalDateTime.parse(date + " " + time, dateTimeFormatter);
                Intrinsics.checkNotNull((Object)localDateTime);
                energyUsage = new EnergyUsage(localDateTime, consumption);
            }
            if (energyUsage == null) continue;
            EnergyUsage it$iv$iv = energyUsage;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getRecordFromLine(String line) {
        List values = new ArrayList();
        Closeable closeable = new Scanner(line);
        Throwable throwable = null;
        try {
            Scanner rowScanner = (Scanner)closeable;
            boolean bl = false;
            rowScanner.useDelimiter(";");
            while (rowScanner.hasNext()) {
                String string = rowScanner.next();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"next(...)");
                values.add(string);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return values;
    }
}

